<?php
include 'koneksi.php';
include 'header2.php'; 

// Check user session
$sesi = $_SESSION['level'];
if ($sesi == "") {
    header("location: login.php");
    exit;
}

// Get ID from URL with validation
$id = isset($_GET["id"]) ? (int)$_GET["id"] : 0;

// Get channel data based on ID
$query = "SELECT * FROM channel WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$mhs = $result->fetch_assoc();

// **If data not found, show error message**
if (!$mhs) {
    echo "<script>
        alert('Data not found!');
        window.location = 'add_channel.php';
    </script>";
    exit;
}

// If submit button is pressed (update data)
if (isset($_POST["submit"])) {
    $nama = $_POST["nama"];
    $views = $_POST["views"];
    $subscribers = $_POST["subscribers"];
    $frekuensi = $_POST["frekuensi"];
    $videos = $_POST["videos"];
    $background = $_POST["background"];

    // Update data
    $query = "UPDATE channel SET nama = ?, views = ?, subscribers = ?, frekuensi = ?, videos = ?, background = ? WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("siiissi", $nama, $views, $subscribers, $frekuensi, $videos, $background, $id);

    if ($stmt->execute()) {
        echo "<script>
            alert('Data successfully updated!');
            window.location = 'channel.php';
        </script>";
    } else {
        echo "<script>alert('Failed to update data!');</script>";
    }
}

// If delete button is pressed
if (isset($_POST["hapus"])) {
    $query = "DELETE FROM channel WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo "<script>
            alert('Data successfully deleted!');
            window.location = 'channel.php';
        </script>";
    } else {
        echo "<script>alert('Failed to delete data!');</script>";
    }
}
?>

<div id="layoutSidenav_content">
    <main>
        <div class="container">
            <div class="py-4 text-center">
                <h2>Update YouTube Channel Data</h2>
            </div>

            <div class="row">
                <div class='col-sm-4'></div>
                <div class='col-sm-5'>
                    <form action="" method="post">
                        <input type="hidden" name="id" value="<?= htmlspecialchars($mhs["id"]); ?>">
                        <table class='table table-bordered'>
                            <tr>
                                <td>Channel Name</td>
                                <td><input type="text" name="nama" class='form-control' value="<?= htmlspecialchars($mhs["nama"]); ?>" required></td>
                            </tr>
                            <tr>
                                <td>Number of Views</td>
                                <td><input type="number" name="views" class='form-control' value="<?= htmlspecialchars($mhs["views"]); ?>" required></td>
                            </tr>
                            <tr>
                                <td>Number of Subscribers</td>
                                <td><input type="number" name="subscribers" class='form-control' value="<?= htmlspecialchars($mhs["subscribers"]); ?>" required></td>
                            </tr>
                            <tr>
                                <td>Upload Frequency</td>
                                <td><input type="text" name="frekuensi" class='form-control' value="<?= htmlspecialchars($mhs["frekuensi"]); ?>" required></td>
                            </tr>
                            <tr>
                                <td>Number of Videos</td>
                                <td><input type="number" name="videos" class='form-control' value="<?= htmlspecialchars($mhs["videos"]); ?>" required></td>
                            </tr>
                            <tr>
                                <td>Content Creator Background</td>
                                <td>
                                    <textarea name="background" class="form-control" rows="3" required><?= htmlspecialchars($mhs["background"]); ?></textarea>
                                </td>
                            </tr>
                            <tr>
                                <td class="text-center" colspan="2">
                                    <button class="btn btn-success" type="submit" name="submit">
                                        <i class="fas fa-save"></i> Update Data
                                    </button>
                                    <button class="btn btn-danger" type="submit" name="hapus" onclick="return confirm('Are you sure you want to delete this data?');">
                                        <i class="fas fa-trash-alt"></i> Delete Data
                                    </button>
                                    <a href="rating2.php" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left"></i> Go Back
                                    </a>
                                </td>
                            </tr>
                        </table>
                    </form>
                </div>
            </div>
        </div>
    </main>
</div>
